<?php

namespace VM\ApiBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use FOS\RestBundle\Controller\Annotations\View;
use VM\ApiBundle\Entity\CompanyAllegroCategoryItem;

class SrodkiTrwaleController extends AbstractController
{
    /**
     * @View(serializerGroups={"simpleList"})
     */
    public function getSrodkiTrwaleAction()
    {
        $User = $this->getUser();
        $Company = $this->getApiGetter()->getUserCompanyOrFalse($User);

        $response = array();
        $srodkiTrwale = $Company->getPlaces();

        foreach($srodkiTrwale as $CompanyAllegroCattegoryItem)
        {
            if(!isset($response[$CompanyAllegroCattegoryItem->getItem()->getId()]))
            {
                $response[$CompanyAllegroCattegoryItem->getItem()->getId()] = array(
                    'item' => $CompanyAllegroCattegoryItem->getItem(),
                    'list' => array()
                );
            }

            $response[$CompanyAllegroCattegoryItem->getItem()->getId()]['list'][] = $CompanyAllegroCattegoryItem;
        }

        return array_values($response);
    }

    /**
     * @View(serializerGroups={"simpleList"})
     */
    public function buySrodekTrwalyAction()
    {
        $this->getDoctrine()->getConnection()->beginTransaction();
        try
        {
            $User = $this->getUser();
            $Company = $this->getApiGetter()->getUserCompanyOrFalse($User);
            $Round = $this->getApiGetter()->getUserActualRound($User);

            $data = $this->getRequest()->request->getIterator()->getArrayCopy();
            $Item = $this->getApiGetter()->getAllegroItem($data['item_id']);

            if($Round->getId() != $data['round_id'])
            {
                throw new \Exception('Round has just changed');
            }

            $CurrentAccount = $this->getApiGetter()->getCompanyCurrentAccount($Company->getId());

            if($data['id'] == 0)
            {
                $CompanyAllegroCategoryItem = new CompanyAllegroCategoryItem();
                $CompanyAllegroCategoryItem->setCompany($Company);
                $CompanyAllegroCategoryItem->setItem($Item);
                $CompanyAllegroCategoryItem->setRound($Round);
                $CompanyAllegroCategoryItem->setPrice($Item->getBuyNowPrice());
                $CompanyAllegroCategoryItem->setQuantity($data['quantity']);
                $CompanyAllegroCategoryItem->setDepreciation($data['depreciation']);

                $this->getDoctrine()->getManager()->persist($CompanyAllegroCategoryItem);
                if(empty($data['loan_type']))
                {
                    $this->getApiCreator()->changeAccountValue($CurrentAccount, $Round, -1 * $CompanyAllegroCategoryItem->getQuantity() * $CompanyAllegroCategoryItem->getPrice(), 'Zakup środka trwałego: ' . $CompanyAllegroCategoryItem->getItem()->getName());
                }
                else
                {
                    $value = $CompanyAllegroCategoryItem->getPrice() * $CompanyAllegroCategoryItem->getQuantity();
                    $BankServiceOption = $this->getApiGetter()->getBankServiceOption($data['loan_type']['id']);
                    $CompanyBankServiceOption = $this->getApiCreator()->createCompanyBankServiceOption($Company, $Round, $BankServiceOption, $value, $CompanyAllegroCategoryItem->getItem()->getName() . ' - ' . $CompanyAllegroCategoryItem->getQuantity() . ' szt.');
                    $CompanyAllegroCategoryItem->setLoan($CompanyBankServiceOption);
                }
            }
            else
            {
                $CompanyAllegroCategoryItem = $this->getApiGetter()->getCompanyAllegroItem($data['id']);

                if($data['quantity'] == 0 && $CompanyAllegroCategoryItem->getRoundId() == $Round->getId())
                {
                    if($CompanyAllegroCategoryItem->getLoanId() > 0)
                    {
                        $this->getDoctrine()->getManager()->remove($CompanyAllegroCategoryItem->getLoan());
                    }
                    else
                    {
                        $this->getApiCreator()->changeAccountValue($CurrentAccount, $Round, $CompanyAllegroCategoryItem->getQuantity() * $CompanyAllegroCategoryItem->getPrice(), 'Rezygnacja ze środka trwałego: ' . $CompanyAllegroCategoryItem->getItem()->getName());
                    }
                    $this->getDoctrine()->getManager()->remove($CompanyAllegroCategoryItem);
                }
            }

            $this->getDoctrine()->getManager()->flush();
            $this->getDoctrine()->getConnection()->commit();

            $companyAllegroCategoryItemId = $CompanyAllegroCategoryItem->getId();
            $this->getDoctrine()->getManager()->clear();


            if(!empty($companyAllegroCategoryItemId))
            {
                $CompanyAllegroCategoryItem = $this->getApiGetter()->getCompanyAllegroItem($companyAllegroCategoryItemId);

                return $CompanyAllegroCategoryItem;
            }
            else
            {
                return true;
            }
        }
        catch(\Exception $Exception)
        {
            $this->getDoctrine()->getConnection()->rollback();
            return false;
        }
    }
}
